function s = stim(varargin)
%
% constructor stim for stim object
%
% A stim object defines the parameters and synthesis code for presenting a
% stimulus. The stim object interacts closely with a presenter object, and
% expects to find particular parameter tags available via the presenter.
% Thus, each type of stim object should be associated with a particular
% set of TDT circuits that define those tags and respond correctly to
% messages generated by the stim object.

if nargin == 0 % create an empty stim object
    s.params = struct;  % structure of stim params controlled by matlab
    s.tags = struct; % structure of tags to set in presenter object
    s.makeStimFunc = @defaultMakeStimFunc; % function to generate tags from params
    s.readyFunc = @defaultReadyFunc; % function to ready presenter object (e.g. upload but don't trigger)
    s.presentFunc = @defaultPresentFunc; % function to make presenter object go (e.g. prep and trigger)
    s.checkBusyFunc = @defaultCheckBusyFunc; % function to check status of stim (still playing?) 

    s = class(s,'stim');

else % has been called with name,value pairs. Use these to fill slots
    if strcmp(class(varargin{1}),'stim') % modify an existing stim
        s = varargin{1};
        varargstart = 2;
    else % or make a new one
        s = stim;
        varargstart = 1;
    end
    
    % fill the slots
    for iArg = varargstart:2:nargin 
        slotname = varargin{iArg};
        slotval = varargin{iArg+1};

        if ~isfield(struct(s),slotname)
            fprintf('\n%s is not a valid stim slot name.',slotname);
        else
            eval(sprintf('s.%s = slotval;',slotname));
        end
    end
end
